const btnSource = document.getElementById('btn-source-crea');
const modal = document.getElementById('source-crea');
const btnClose = modal ? modal.querySelector('.close-btn') : null;

if (btnSource && modal && btnClose) {
    btnSource.addEventListener('click', () => {
        modal.setAttribute('aria-hidden', 'false');
    });

    btnClose.addEventListener('click', () => {
        modal.setAttribute('aria-hidden', 'true');
    });

    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.setAttribute('aria-hidden', 'true');
        }
    });

    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal.getAttribute('aria-hidden') === 'false') {
            modal.setAttribute('aria-hidden', 'true');
        }
    });
}